<?php
require_once __DIR__ . '/../includes/helpers.php';
$cfg = app_cfg();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?=h($cfg['app_name'])?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width:900px;">
  <div class="card shadow-sm">
    <div class="card-body p-4">
      <h3 class="mb-2"><?=h($cfg['app_name'])?></h3>
      <div class="text-secondary mb-3">Hosted Loyalty Popup + API endpoints (MVP)</div>

      <div class="row g-3">
        <div class="col-md-6">
          <div class="p-3 border rounded bg-white">
            <div class="fw-bold mb-1">POS Popup</div>
            <div class="text-secondary small mb-2">Use this in RMS after tender.</div>
            <a class="btn btn-primary" href="loyalty_popup.html">Open Loyalty Popup</a>
          </div>
        </div>
        <div class="col-md-6">
          <div class="p-3 border rounded bg-white">
            <div class="fw-bold mb-1">Admin</div>
            <div class="text-secondary small mb-2">Manage rules & monitor points.</div>
            <a class="btn btn-dark" href="../admin/login.php">Admin Login</a>
          </div>
        </div>
      </div>

      <hr class="my-4">

      <div class="small text-secondary">
        Install: import <code>schema.sql</code>, update <code>config/app.php</code>, then open <code>/public/</code>.
      </div>
    </div>
  </div>
</div>
</body>
</html>
