<?php
require_once __DIR__ . '/../includes/helpers.php';
require_admin();
$db = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $is_active = isset($_POST['is_active']) ? 1 : 0;
  $ppk = (float)($_POST['points_per_kes'] ?? 0.02);
  $min = (float)($_POST['min_spend'] ?? 0);
  $max = trim((string)($_POST['max_points_per_sale'] ?? ''));
  $maxv = ($max === '') ? null : (int)$max;
  $note = trim((string)($_POST['note'] ?? 'Rule'));

  $stmt = $db->prepare("INSERT INTO loyalty_rules (is_active, points_per_kes, min_spend, max_points_per_sale, note) VALUES (?, ?, ?, ?, ?)");
  // For nullable int, bind as i but provide null via set to NULL in SQL if empty: simplest MVP: store null if 0 and max blank
  if ($max === '') {
    $stmt->close();
    $stmt = $db->prepare("INSERT INTO loyalty_rules (is_active, points_per_kes, min_spend, max_points_per_sale, note) VALUES (?, ?, ?, NULL, ?)");
    $stmt->bind_param("idds", $is_active, $ppk, $min, $note);
  } else {
    $stmt->bind_param("iddis", $is_active, $ppk, $min, $maxv, $note);
  }
  $stmt->execute();
  $stmt->close();

  flash_set('Rule saved.', 'success');
  header("Location: " . base_url() . "/admin/rules.php");
  exit;
}

$rules = $db->query("SELECT * FROM loyalty_rules ORDER BY id DESC LIMIT 30")->fetch_all(MYSQLI_ASSOC);
$csrf = csrf_token();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Rules • SmartPay Loyalty</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg bg-dark navbar-dark">
  <div class="container">
    <a class="navbar-brand" href="<?=h(base_url())?>/admin/index.php">SmartPay Loyalty</a>
    <div class="ms-auto d-flex gap-2">
      <a class="btn btn-outline-light btn-sm" href="<?=h(base_url())?>/admin/index.php">Dashboard</a>
      <a class="btn btn-outline-light btn-sm" href="<?=h(base_url())?>/admin/logout.php">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="mb-3">Create Rule</h5>
      <form method="post" class="row g-3">
        <input type="hidden" name="_csrf" value="<?=h($csrf)?>">
        <div class="col-md-3">
          <label class="form-label">Active</label>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" checked>
            <label class="form-check-label">Use this rule</label>
          </div>
        </div>
        <div class="col-md-3">
          <label class="form-label">Points per KES</label>
          <input class="form-control" name="points_per_kes" value="0.0200" step="0.0001">
          <div class="form-text">0.02 means 1 point per KES 50.</div>
        </div>
        <div class="col-md-3">
          <label class="form-label">Min spend (KES)</label>
          <input class="form-control" name="min_spend" value="0.00" step="0.01">
        </div>
        <div class="col-md-3">
          <label class="form-label">Max points per sale</label>
          <input class="form-control" name="max_points_per_sale" placeholder="optional">
        </div>
        <div class="col-md-12">
          <label class="form-label">Note</label>
          <input class="form-control" name="note" value="1 point per KES 50">
        </div>
        <div class="col-md-12">
          <button class="btn btn-primary">Save Rule</button>
        </div>
      </form>
    </div>
  </div>

  <div class="card shadow-sm mt-4">
    <div class="card-body">
      <h5 class="mb-3">Recent Rules</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>ID</th><th>Active</th><th>points_per_kes</th><th>min_spend</th><th>max</th><th>note</th><th>updated</th></tr></thead>
          <tbody>
            <?php foreach($rules as $r): ?>
              <tr>
                <td><?=h($r['id'])?></td>
                <td><?= $r['is_active'] ? '✅' : '—' ?></td>
                <td><?=h($r['points_per_kes'])?></td>
                <td><?=h($r['min_spend'])?></td>
                <td><?=h($r['max_points_per_sale'] ?? '—')?></td>
                <td><?=h($r['note'])?></td>
                <td><?=h($r['updated_at'])?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>
</body>
</html>
